<?php

use yii\helpers\Html;
use yii\widgets\ActiveForm;

$this->title = 'Регистрация';
?>

<div class="site-signup">
    <div style="max-width: 800px; margin: 0 auto;">
        <div class="card">
            <div class="card-header">
                <h1 class="card-title" style="text-align: center; margin: 0;"><?= Html::encode($this->title) ?></h1>
            </div>
            <div class="card-body">
                <p style="text-align: center; color: #666; margin-bottom: 20px;">Пожалуйста, заполните все поля для регистрации:</p>

                <?php $form = ActiveForm::begin([
                    'id' => 'form-signup',
                    'options' => ['class' => 'form']
                ]); ?>

                <div style="display: flex; gap: 20px; margin-bottom: 20px;">
                    <div style="flex: 1;">
                        <?= $form->field($model, 'full_name')->textInput([
                            'class' => 'form-control',
                            'placeholder' => 'Иванов Иван Иванович'
                        ])->label('ФИО') ?>
                    </div>
                    <div style="flex: 1;">
                        <?= $form->field($model, 'phone')->widget(\yii\widgets\MaskedInput::class, [
                            'mask' => '8(999)999-99-99',
                            'options' => [
                                'class' => 'form-control',
                                'placeholder' => '8(XXX)XXX-XX-XX'
                            ]
                        ])->label('Телефон') ?>
                    </div>
                </div>

                <div style="display: flex; gap: 20px; margin-bottom: 20px;">
                    <div style="flex: 1;">
                        <?= $form->field($model, 'email')->textInput([
                            'class' => 'form-control',
                            'type' => 'email',
                            'placeholder' => 'example@mail.ru'
                        ])->label('Email') ?>
                    </div>
                    <div style="flex: 1;">
                        <?= $form->field($model, 'residents_count')->textInput([
                            'class' => 'form-control',
                            'type' => 'number',
                            'min' => 1,
                            'placeholder' => '1'
                        ])->label('Количество проживающих') ?>
                    </div>
                </div>

                <div style="margin-bottom: 20px;">
                    <?= $form->field($model, 'address')->textarea([
                        'class' => 'form-control',
                        'rows' => 2,
                        'placeholder' => 'г. Москва, ул. Примерная, д. 1, кв. 1'
                    ])->label('Адрес проживания') ?>
                </div>

                <div style="display: flex; gap: 20px; margin-bottom: 20px;">
                    <div style="flex: 1;">
                        <?= $form->field($model, 'password')->passwordInput([
                            'class' => 'form-control',
                            'placeholder' => 'Минимум 10 символов'
                        ])->label('Пароль') ?>
                    </div>
                    <div style="flex: 1;">
                        <?= $form->field($model, 'password_repeat')->passwordInput([
                            'class' => 'form-control',
                            'placeholder' => 'Повторите пароль'
                        ])->label('Повтор пароля') ?>
                    </div>
                </div>

                <div style="margin-bottom: 20px; display: flex; align-items: center; gap: 10px;">
                    <?= $form->field($model, 'agree_terms', [
                        'template' => '{input} {label}',
                        'options' => ['style' => 'margin-bottom: 0;']
                    ])->checkbox([
                        'style' => 'margin-right: 5px;'
                    ]) ?>
                </div>

                <div style="margin-top: 20px;">
                    <?= Html::submitButton('Зарегистрироваться', ['class' => 'btn btn-success', 'name' => 'signup-button', 'style' => 'width: 100%;']) ?>
                </div>

                <?php ActiveForm::end(); ?>

                <div style="text-align: center; margin-top: 20px;">
                    <p>Уже зарегистрированы?</p>
                    <?= Html::a('Войти', ['site/login'], ['class' => 'btn btn-link']) ?>
                </div>
            </div>
        </div>
    </div>
</div>