<?php

use yii\helpers\Html;
use yii\helpers\Url;
use yii\widgets\ActiveForm;

$this->title = 'Вход';
?>

<div class="site-login">
    <div style="max-width: 400px; margin: 0 auto;">
        <div class="card">
            <div class="card-header">
                <h1 class="card-title" style="text-align: center; margin: 0;"><?= Html::encode($this->title) ?></h1>
            </div>
            <div class="card-body">
                <p style="text-align: center; color: #666; margin-bottom: 20px;">Пожалуйста, заполните поля для входа:</p>

                <?php $form = ActiveForm::begin([
                    'id' => 'login-form',
                    'options' => ['class' => 'form']
                ]); ?>

                <div class="form-group">
                    <?= $form->field($model, 'phone')->widget(\yii\widgets\MaskedInput::class, [
                        'mask' => '8(999)999-99-99',
                        'options' => [
                            'class' => 'form-control',
                            'placeholder' => '8(XXX)XXX-XX-XX'
                        ]
                    ])->label('Телефон') ?>
                </div>

                <div class="form-group">
                    <?= $form->field($model, 'password')->passwordInput([
                        'class' => 'form-control',
                        'placeholder' => 'Введите пароль'
                    ])->label('Пароль') ?>
                </div>

                <div class="form-group" style="display: flex; align-items: center; gap: 10px;">
                    <?= $form->field($model, 'rememberMe', [
                        'template' => '{input} {label}',
                        'options' => ['style' => 'margin-bottom: 0;']
                    ])->checkbox([
                        'style' => 'margin-right: 5px;'
                    ]) ?>
                </div>

                <div class="form-group" style="margin-top: 20px;">
                    <?= Html::submitButton('Войти', ['class' => 'btn btn-primary', 'name' => 'login-button', 'style' => 'width: 100%;']) ?>
                </div>

                <?php ActiveForm::end(); ?>

                <div style="text-align: center; margin-top: 20px;">
                    <p>Еще не зарегистрированы?</p>
                    <?= Html::a('Регистрация', ['site/signup'], ['class' => 'btn btn-link']) ?>
                </div>
                
                <div style="background: #e3f2fd; border: 1px solid #bbdefb; border-radius: 4px; padding: 15px; margin-top: 20px;">
                    <h5 style="margin-top: 0; color: #1565c0;">Тестовый аккаунт администратора:</h5>
                    <p style="margin-bottom: 5px;"><strong>Телефон:</strong> 8(000)000-00-00</p>
                    <p style="margin-bottom: 0;"><strong>Пароль:</strong> kommunalshik</p>
                </div>
            </div>
        </div>
    </div>
</div>