<?php

use yii\helpers\Html;
use yii\helpers\Url;
use app\models\News;

$this->title = 'Коммуналка - Портал для передачи показаний';
$news = News::getActiveNews(3);

// Функция для форматирования даты
function formatDate($date) {
    $months = [
        1 => 'января', 2 => 'февраля', 3 => 'марта', 4 => 'апреля',
        5 => 'мая', 6 => 'июня', 7 => 'июля', 8 => 'августа',
        9 => 'сентября', 10 => 'октября', 11 => 'ноября', 12 => 'декабря'
    ];
    
    if (empty($date)) {
        return '';
    }
    
    if (is_string($date)) {
        $timestamp = strtotime($date);
    } else {
        $timestamp = $date;
    }
    
    $day = date('j', $timestamp);
    $month = $months[date('n', $timestamp)];
    $year = date('Y', $timestamp);
    
    return $day . ' ' . $month . ' ' . $year . ' года';
}
?>

<div class="site-index">
    <!-- Hero Section -->
    <div class="jumbotron">
        <h1>Коммуналка</h1>
        <p>Портал для передачи показаний за коммунальные услуги через сеть Интернет</p>
        
        <?php if (Yii::$app->user->isGuest): ?>
            <div style="display: flex; gap: 10px; justify-content: center; flex-wrap: wrap;">
                <?= Html::a('Войти', ['site/login'], ['class' => 'btn btn-primary', 'style' => 'padding: 12px 30px; font-size: 1.1rem;']) ?>
                <?= Html::a('Зарегистрироваться', ['site/signup'], ['class' => 'btn btn-success', 'style' => 'padding: 12px 30px; font-size: 1.1rem;']) ?>
            </div>
        <?php else: ?>
            <div style="display: flex; gap: 10px; justify-content: center; flex-wrap: wrap;">
                <?= Html::a('Передать показания', ['meter-reading/create'], ['class' => 'btn btn-primary', 'style' => 'padding: 12px 30px; font-size: 1.1rem;']) ?>
                <?= Html::a('Мои показания', ['meter-reading/index'], ['class' => 'btn btn-info', 'style' => 'padding: 12px 30px; font-size: 1.1rem;']) ?>
                <?= Html::a('Мой профиль', ['profile/index'], ['class' => 'btn btn-success', 'style' => 'padding: 12px 30px; font-size: 1.1rem;']) ?>
            </div>
        <?php endif; ?>
    </div>

    <!-- Features -->
    <div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(300px, 1fr)); gap: 30px; margin-bottom: 40px;">
        <div class="card">
            <div style="text-align: center; margin-bottom: 15px;">
                <i class="fas fa-bolt" style="font-size: 3rem; color: #f39c12;"></i>
            </div>
            <h3 style="text-align: center; margin-bottom: 15px;">Передача показаний</h3>
            <p style="text-align: center; color: #666;">Удобная онлайн-передача показаний счетчиков за электричество, газ и воду</p>
        </div>

        <div class="card">
            <div style="text-align: center; margin-bottom: 15px;">
                <i class="fas fa-chart-line" style="font-size: 3rem; color: #3498db;"></i>
            </div>
            <h3 style="text-align: center; margin-bottom: 15px;">История платежей</h3>
            <p style="text-align: center; color: #666;">Просмотр истории всех переданных показаний и оплат за любой период</p>
        </div>

        <div class="card">
            <div style="text-align: center; margin-bottom: 15px;">
                <i class="fas fa-headset" style="font-size: 3rem; color: #2ecc71;"></i>
            </div>
            <h3 style="text-align: center; margin-bottom: 15px;">Поддержка 24/7</h3>
            <p style="text-align: center; color: #666;">Круглосуточная поддержка пользователей по всем вопросам</p>
        </div>
    </div>

    <!-- Main Content -->
    <div style="display: flex; gap: 30px; flex-wrap: wrap;">
        <!-- Left Column -->
        <div style="flex: 2; min-width: 300px;">
            <!-- Welcome Message -->
            <div class="card" style="margin-bottom: 30px;">
                <div class="card-header">
                    <h2 class="card-title">Добро пожаловать на портал "Коммуналка"!</h2>
                </div>
                <div class="card-body">
                    <p>Наш портал создан для удобной передачи показаний счетчиков за коммунальные услуги. Теперь вам не нужно стоять в очередях или заполнять бумажные квитанции - все можно сделать онлайн!</p>
                    
                    <h4 style="margin-top: 20px; margin-bottom: 15px;">Как пользоваться порталом:</h4>
                    <ol style="padding-left: 20px; margin-bottom: 0;">
                        <li>Зарегистрируйтесь на портале</li>
                        <li>Войдите в личный кабинет</li>
                        <li>Передавайте показания счетчиков</li>
                        <li>Следите за статусом ваших заявок</li>
                        <li>Оплачивайте счета онлайн</li>
                    </ol>
                </div>
            </div>

            <!-- Instructions -->
            <div class="card">
                <div class="card-header" style="background: #17a2b8; color: white;">
                    <h3 class="card-title" style="margin: 0; color: white;">Правила снятия показаний</h3>
                </div>
                <div class="card-body">
                    <div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(200px, 1fr)); gap: 20px;">
                        <div style="text-align: center; padding: 20px; background: #f8f9fa; border-radius: 8px;">
                            <i class="fas fa-bolt" style="font-size: 2.5rem; color: #f39c12; margin-bottom: 15px;"></i>
                            <h4>Электричество</h4>
                            <p style="font-size: 0.9rem; color: #666;">Снимайте показания в конце месяца. Учитывайте все цифры до запятой.</p>
                        </div>
                        
                        <div style="text-align: center; padding: 20px; background: #f8f9fa; border-radius: 8px;">
                            <i class="fas fa-fire" style="font-size: 2.5rem; color: #e74c3c; margin-bottom: 15px;"></i>
                            <h4>Газ</h4>
                            <p style="font-size: 0.9rem; color: #666;">Показания снимаются 25-30 числа каждого месяца.</p>
                        </div>
                        
                        <div style="text-align: center; padding: 20px; background: #f8f9fa; border-radius: 8px;">
                            <i class="fas fa-tint" style="font-size: 2.5rem; color: #3498db; margin-bottom: 15px;"></i>
                            <h4>Вода</h4>
                            <p style="font-size: 0.9rem; color: #666;">Учитывайте показания горячей и холодной воды отдельно.</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Right Column -->
        <div style="flex: 1; min-width: 300px;">
            <!-- Contact Info -->
            <div class="card" style="margin-bottom: 30px;">
                <div class="card-header" style="background: #3498db; color: white;">
                    <h3 class="card-title" style="margin: 0; color: white;">Контакты и поддержка</h3>
                </div>
                <div class="card-body">
                    <div style="margin-bottom: 15px;">
                        <h5 style="color: #2c3e50; margin-bottom: 5px;">
                            <i class="fas fa-phone" style="margin-right: 10px; color: #3498db;"></i>
                            Телефон поддержки:
                        </h5>
                        <p style="margin-left: 26px; margin-bottom: 15px;">8(800)123-45-67</p>
                    </div>
                    
                    <div style="margin-bottom: 15px;">
                        <h5 style="color: #2c3e50; margin-bottom: 5px;">
                            <i class="fas fa-envelope" style="margin-right: 10px; color: #3498db;"></i>
                            Email:
                        </h5>
                        <p style="margin-left: 26px; margin-bottom: 15px;">support@kommunalka.ru</p>
                    </div>
                    
                    <div style="margin-bottom: 20px;">
                        <h5 style="color: #2c3e50; margin-bottom: 5px;">
                            <i class="fas fa-clock" style="margin-right: 10px; color: #3498db;"></i>
                            Часы работы:
                        </h5>
                        <p style="margin-left: 26px; margin-bottom: 0;">Пн-Пт: 9:00-18:00</p>
                    </div>
                    
                    <button id="start-chat" class="btn btn-success" style="width: 100%;">
                        <i class="fas fa-comments" style="margin-right: 8px;"></i>
                        Начать чат
                    </button>
                </div>
            </div>

            <!-- Important Info -->
            <div class="card" style="margin-bottom: 30px;">
                <div class="card-header" style="background: #f39c12; color: white;">
                    <h3 class="card-title" style="margin: 0; color: white;">Важная информация</h3>
                </div>
                <div class="card-body">
                    <div style="background: #fff3cd; border: 1px solid #ffeaa7; border-radius: 4px; padding: 15px; margin-bottom: 15px;">
                        <h5 style="margin-top: 0; color: #856404;">
                            <i class="fas fa-exclamation-triangle" style="margin-right: 8px;"></i>
                            Сроки подачи
                        </h5>
                        <p style="margin-bottom: 0;">Показания принимаются до <strong>25 числа</strong> каждого месяца.</p>
                    </div>
                    
                    <div style="background: #d1ecf1; border: 1px solid #bee5eb; border-radius: 4px; padding: 15px;">
                        <h5 style="margin-top: 0; color: #0c5460;">
                            <i class="fas fa-calendar-alt" style="margin-right: 8px;"></i>
                            График отключений
                        </h5>
                        <p style="margin-bottom: 0;">Плановые работы: 15-16 числа каждого месяца.</p>
                    </div>
                </div>
            </div>

            <!-- News -->
            <div class="card">
                <div class="card-header" style="background: #27ae60; color: white;">
                    <h3 class="card-title" style="margin: 0; color: white;">Новости и объявления</h3>
                </div>
                <div class="card-body">
                    <?php if ($news): ?>
                        <?php foreach ($news as $item): ?>
                            <div style="margin-bottom: 20px; padding-bottom: 20px; border-bottom: 1px solid #eee; transition: background-color 0.3s;">
                                <h5 style="margin-top: 0; margin-bottom: 5px; color: #2c3e50;">
                                    <?= Html::encode($item->title) ?>
                                </h5>
                                <small style="color: #666;">
                                    <i class="far fa-calendar" style="margin-right: 5px;"></i>
                                    <?= formatDate($item->publish_date) ?>
                                </small>
                                <p style="margin-top: 10px; margin-bottom: 0; color: #555;">
                                    <?= nl2br(Html::encode($item->content)) ?>
                                </p>
                            </div>
                        <?php endforeach; ?>
                    <?php else: ?>
                        <p style="color: #666; text-align: center; margin: 0;">Новостей пока нет.</p>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    // Чат поддержки
    document.getElementById('start-chat').addEventListener('click', function(e) {
        e.preventDefault();
        alert('Чат поддержки откроется в новом окне. В рабочем приложении здесь будет реализован чат.');
    });
    
    // Анимация для карточек
    const cards = document.querySelectorAll('.card');
    cards.forEach(card => {
        card.style.transition = 'transform 0.3s, box-shadow 0.3s';
        card.addEventListener('mouseenter', function() {
            this.style.transform = 'translateY(-5px)';
            this.style.boxShadow = '0 10px 20px rgba(0,0,0,0.1)';
        });
        card.addEventListener('mouseleave', function() {
            this.style.transform = 'translateY(0)';
            this.style.boxShadow = '0 2px 10px rgba(0,0,0,0.05)';
        });
    });
    
    // Анимация для кнопок
    const buttons = document.querySelectorAll('.btn');
    buttons.forEach(button => {
        button.style.transition = 'all 0.3s';
        button.addEventListener('mouseenter', function() {
            this.style.transform = 'translateY(-2px)';
        });
        button.addEventListener('mouseleave', function() {
            this.style.transform = 'translateY(0)';
        });
    });
});
</script>