<?php

use yii\helpers\Html;
use yii\widgets\ActiveForm;

$this->title = 'Смена пароля';
$this->params['breadcrumbs'][] = ['label' => 'Профиль', 'url' => ['index']];
$this->params['breadcrumbs'][] = $this->title;
?>

<div class="profile-change-password">
    <div style="max-width: 600px; margin: 0 auto;">
        <div class="card">
            <div class="card-header">
                <h4 class="mb-0"><?= Html::encode($this->title) ?></h4>
            </div>
            <div class="card-body">
                <p style="color: #666; margin-bottom: 20px;">Для смены пароля заполните поля ниже. Пароль должен содержать минимум 10 символов.</p>

                <?php $form = ActiveForm::begin([
                    'id' => 'change-password-form',
                    'fieldConfig' => [
                        'template' => "{label}\n{input}\n{error}",
                        'labelOptions' => ['class' => 'control-label'],
                        'inputOptions' => ['class' => 'form-control'],
                        'errorOptions' => ['class' => 'text-danger'],
                    ],
                ]); ?>

                <div style="margin-bottom: 20px;">
                    <?= $form->field($model, 'password')->passwordInput(['placeholder' => 'Новый пароль']) ?>
                </div>

                <div style="margin-bottom: 20px;">
                    <?= $form->field($model, 'password_repeat')->passwordInput(['placeholder' => 'Повторите новый пароль']) ?>
                </div>

                <div style="display: flex; gap: 15px; margin-top: 20px;">
                    <?= Html::submitButton('Сменить пароль', ['class' => 'btn btn-primary']) ?>
                    <?= Html::a('Отмена', ['index'], ['class' => 'btn btn-link']) ?>
                </div>

                <?php ActiveForm::end(); ?>
            </div>
        </div>
    </div>
</div>