<?php

use yii\helpers\Html;
use yii\helpers\Url;

$this->title = 'Мои показания';
$this->params['breadcrumbs'][] = $this->title;

// Функции для форматирования
function formatDecimal($value, $decimals = 3) {
    if ($value === null || $value === '') {
        return '';
    }
    return number_format($value, $decimals, ',', ' ');
}

function formatCurrency($value) {
    if ($value === null || $value === '') {
        return '';
    }
    return number_format($value, 2, ',', ' ') . ' ₽';
}

function formatDate($date) {
    if (empty($date)) {
        return '';
    }
    
    if (is_string($date)) {
        $timestamp = strtotime($date);
    } else {
        $timestamp = $date;
    }
    
    return date('d.m.Y', $timestamp);
}
?>

<div class="meter-reading-index">
    <div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 30px; flex-wrap: wrap; gap: 15px;">
        <h1 style="margin: 0;"><?= Html::encode($this->title) ?></h1>
        <?= Html::a('Передать показания', ['create'], ['class' => 'btn btn-primary']) ?>
    </div>

    <?php if ($dataProvider->getTotalCount() > 0): ?>
        <div class="card">
            <div class="card-body">
                <table class="table">
                    <thead>
                        <tr>
                            <th>Дата</th>
                            <th>Услуга</th>
                            <th>Предыдущие</th>
                            <th>Текущие</th>
                            <th>Расход</th>
                            <th>Сумма</th>
                            <th>Статус</th>
                            <th>Действия</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($dataProvider->getModels() as $model): ?>
                            <tr>
                                <td><?= formatDate($model->reading_date) ?></td>
                                <td><?= Html::encode($model->serviceCategory->name ?? '') ?></td>
                                <td><?= formatDecimal($model->previous_reading, 3) ?></td>
                                <td><?= formatDecimal($model->current_reading, 3) ?></td>
                                <td><?= formatDecimal($model->consumption, 3) ?></td>
                                <td><?= formatCurrency($model->amount) ?></td>
                                <td>
                                    <span style="display: inline-block; padding: 4px 12px; border-radius: 4px; font-size: 0.9rem; 
                                          background: <?= $model->status === 'Новая' ? '#fff3cd' : 
                                                       ($model->status === 'Показания приняты' ? '#d1ecf1' : 
                                                       ($model->status === 'Оплачено' ? '#d4edda' : '#f8d7da')) ?>; 
                                          color: <?= $model->status === 'Новая' ? '#856404' : 
                                                  ($model->status === 'Показания приняты' ? '#0c5460' : 
                                                  ($model->status === 'Оплачено' ? '#155724' : '#721c24')) ?>; 
                                          border: 1px solid <?= $model->status === 'Новая' ? '#ffeaa7' : 
                                                              ($model->status === 'Показания приняты' ? '#bee5eb' : 
                                                              ($model->status === 'Оплачено' ? '#c3e6cb' : '#f5c6cb')) ?>;">
                                        <?= Html::encode($model->status) ?>
                                    </span>
                                </td>
                                <td>
                                    <?= Html::a('Просмотр', ['view', 'id' => $model->id], [
                                        'class' => 'btn btn-link',
                                        'style' => 'padding: 0;'
                                    ]) ?>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        </div>
    <?php else: ?>
        <div class="card">
            <div class="card-body" style="text-align: center; padding: 40px;">
                <i class="fas fa-clipboard-list" style="font-size: 4rem; color: #ddd; margin-bottom: 20px;"></i>
                <h3 style="color: #666; margin-bottom: 15px;">Показания отсутствуют</h3>
                <p style="color: #999; margin-bottom: 30px;">Вы еще не передавали показания счетчиков</p>
                <?= Html::a('Передать первые показания', ['create'], ['class' => 'btn btn-primary']) ?>
            </div>
        </div>
    <?php endif; ?>
</div>