<?php

use yii\helpers\Html;
use yii\helpers\Url;

/* @var $this \yii\web\View */
/* @var $content string */

\yii\web\YiiAsset::register($this);
?>
<?php $this->beginPage() ?>
<!DOCTYPE html>
<html lang="<?= Yii::$app->language ?>">
<head>
    <meta charset="<?= Yii::$app->charset ?>">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <?= Html::csrfMetaTags() ?>
    <title><?= Html::encode($this->title) ?> - Коммуналка</title>
    
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            line-height: 1.6;
            color: #333;
            background-color: #f5f5f5;
        }
        
        .container {
            max-width: 1200px;
            margin: 0 auto;
            padding: 0 20px;
        }
        
        /* Header */
        .header {
            background: linear-gradient(135deg, #2c3e50, #4a6491);
            color: white;
            padding: 1rem 0;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
        }
        
        .header .container {
            display: flex;
            justify-content: space-between;
            align-items: center;
        }
        
        .logo {
            font-size: 1.8rem;
            font-weight: bold;
            text-decoration: none;
            color: white;
            display: flex;
            align-items: center;
            gap: 10px;
        }
        
        .logo i {
            font-size: 2rem;
        }
        
        .nav {
            display: flex;
            list-style: none;
            gap: 20px;
        }
        
        .nav a {
            color: white;
            text-decoration: none;
            padding: 8px 16px;
            border-radius: 4px;
            transition: background-color 0.3s;
        }
        
        .nav a:hover {
            background-color: rgba(255,255,255,0.1);
        }
        
        .nav a.active {
            background-color: rgba(255,255,255,0.2);
        }
        
        /* Main Content */
        .main-content {
            min-height: calc(100vh - 160px);
            padding: 30px 0;
        }
        
        /* Footer */
        .footer {
            background: #2c3e50;
            color: white;
            padding: 40px 0 20px;
            margin-top: 40px;
        }
        
        .footer-content {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
            gap: 30px;
            margin-bottom: 30px;
        }
        
        .footer-section h5 {
            margin-bottom: 15px;
            font-size: 1.2rem;
        }
        
        .footer-bottom {
            text-align: center;
            padding-top: 20px;
            border-top: 1px solid rgba(255,255,255,0.1);
            color: rgba(255,255,255,0.7);
        }
        
        /* Cards */
        .card {
            background: white;
            border-radius: 8px;
            padding: 25px;
            margin-bottom: 20px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.05);
            border: 1px solid #e0e0e0;
        }
        
        .card-header {
            margin-bottom: 20px;
            padding-bottom: 15px;
            border-bottom: 2px solid #f0f0f0;
        }
        
        .card-title {
            font-size: 1.4rem;
            color: #2c3e50;
            margin: 0;
        }
        
        /* Buttons */
        .btn {
            display: inline-block;
            padding: 10px 24px;
            border: none;
            border-radius: 4px;
            cursor: pointer;
            font-size: 1rem;
            text-decoration: none;
            transition: all 0.3s;
            font-weight: 500;
        }
        
        .btn-primary {
            background: #3498db;
            color: white;
        }
        
        .btn-primary:hover {
            background: #2980b9;
            transform: translateY(-2px);
            box-shadow: 0 4px 8px rgba(52, 152, 219, 0.3);
        }
        
        .btn-success {
            background: #27ae60;
            color: white;
        }
        
        .btn-success:hover {
            background: #219653;
            transform: translateY(-2px);
            box-shadow: 0 4px 8px rgba(39, 174, 96, 0.3);
        }
        
        .btn-danger {
            background: #e74c3c;
            color: white;
        }
        
        .btn-danger:hover {
            background: #c0392b;
            transform: translateY(-2px);
            box-shadow: 0 4px 8px rgba(231, 76, 60, 0.3);
        }
        
        .btn-info {
            background: #17a2b8;
            color: white;
        }
        
        .btn-info:hover {
            background: #138496;
            transform: translateY(-2px);
        }
        
        .btn-link {
            background: transparent;
            color: #3498db;
            padding: 10px 0;
        }
        
        .btn-link:hover {
            color: #2980b9;
            text-decoration: underline;
        }
        
        /* Forms */
        .form-group {
            margin-bottom: 20px;
        }
        
        .form-label {
            display: block;
            margin-bottom: 8px;
            font-weight: 500;
            color: #2c3e50;
        }
        
        .form-control {
            width: 100%;
            padding: 10px 12px;
            border: 1px solid #ddd;
            border-radius: 4px;
            font-size: 1rem;
            transition: border-color 0.3s;
        }
        
        .form-control:focus {
            outline: none;
            border-color: #3498db;
            box-shadow: 0 0 0 2px rgba(52, 152, 219, 0.2);
        }
        
        .invalid-feedback {
            color: #e74c3c;
            font-size: 0.9rem;
            margin-top: 5px;
        }
        
        /* Alerts */
        .alert {
            padding: 15px 20px;
            border-radius: 4px;
            margin-bottom: 20px;
            border: 1px solid transparent;
        }
        
        .alert-success {
            background-color: #d4edda;
            border-color: #c3e6cb;
            color: #155724;
        }
        
        .alert-danger {
            background-color: #f8d7da;
            border-color: #f5c6cb;
            color: #721c24;
        }
        
        .alert-info {
            background-color: #d1ecf1;
            border-color: #bee5eb;
            color: #0c5460;
        }
        
        .alert-warning {
            background-color: #fff3cd;
            border-color: #ffeaa7;
            color: #856404;
        }
        
        /* Tables */
        .table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 20px;
        }
        
        .table th {
            background: #f8f9fa;
            padding: 12px;
            text-align: left;
            border-bottom: 2px solid #dee2e6;
            font-weight: 600;
            color: #2c3e50;
        }
        
        .table td {
            padding: 12px;
            border-bottom: 1px solid #dee2e6;
        }
        
        .table tr:hover {
            background: #f8f9fa;
        }
        
        /* Grid */
        .row {
            display: flex;
            flex-wrap: wrap;
            margin: 0 -15px;
        }
        
        .col {
            padding: 0 15px;
            flex: 1;
            min-width: 300px;
        }
        
        .col-6 {
            width: 50%;
            padding: 0 15px;
        }
        
        .col-4 {
            width: 33.333%;
            padding: 0 15px;
        }
        
        .col-3 {
            width: 25%;
            padding: 0 15px;
        }
        
        /* Jumbotron */
        .jumbotron {
            background: linear-gradient(135deg, #3498db, #2c3e50);
            color: white;
            padding: 60px 40px;
            border-radius: 10px;
            text-align: center;
            margin-bottom: 40px;
        }
        
        .jumbotron h1 {
            font-size: 2.5rem;
            margin-bottom: 20px;
        }
        
        .jumbotron p {
            font-size: 1.2rem;
            max-width: 800px;
            margin: 0 auto 30px;
        }
        
        /* Responsive */
        @media (max-width: 768px) {
            .header .container {
                flex-direction: column;
                gap: 15px;
            }
            
            .nav {
                flex-wrap: wrap;
                justify-content: center;
            }
            
            .col-6, .col-4, .col-3 {
                width: 100%;
            }
            
            .jumbotron {
                padding: 40px 20px;
            }
            
            .jumbotron h1 {
                font-size: 2rem;
            }
        }
    </style>
    
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css">
    <?php $this->head() ?>
</head>
<body>
<?php $this->beginBody() ?>

<header class="header">
    <div class="container">
        <a href="<?= Url::to(['site/index']) ?>" class="logo">
            <i class="fas fa-home"></i>
            <span>Коммуналка</span>
        </a>
        
        <nav>
            <ul class="nav">
                <li><a href="<?= Url::to(['site/index']) ?>" class="<?= Yii::$app->controller->id === 'site' && Yii::$app->controller->action->id === 'index' ? 'active' : '' ?>">Главная</a></li>
                
                <?php if (Yii::$app->user->isGuest): ?>
                    <li><a href="<?= Url::to(['site/login']) ?>" class="<?= Yii::$app->controller->action->id === 'login' ? 'active' : '' ?>">Войти</a></li>
                    <li><a href="<?= Url::to(['site/signup']) ?>" class="<?= Yii::$app->controller->action->id === 'signup' ? 'active' : '' ?>">Регистрация</a></li>
                <?php else: ?>
                    <li><a href="<?= Url::to(['profile/index']) ?>" class="<?= Yii::$app->controller->id === 'profile' ? 'active' : '' ?>">Профиль</a></li>
                    <li><a href="<?= Url::to(['meter-reading/index']) ?>" class="<?= Yii::$app->controller->id === 'meter-reading' ? 'active' : '' ?>">Мои показания</a></li>
                    <li><a href="<?= Url::to(['meter-reading/create']) ?>">Передать показания</a></li>
                    
                    <?php if (Yii::$app->user->identity->phone === '8(000)000-00-00'): ?>
                        <li><a href="<?= Url::to(['admin/index']) ?>" class="<?= Yii::$app->controller->id === 'admin' ? 'active' : '' ?>">Админ</a></li>
                    <?php endif; ?>
                    
                    <li>
                        <form action="<?= Url::to(['site/logout']) ?>" method="post" style="display: inline;">
                            <input type="hidden" name="<?= Yii::$app->request->csrfParam ?>" value="<?= Yii::$app->request->csrfToken ?>">
                            <button type="submit" class="btn btn-link" style="color: white; padding: 8px 16px;">
                                Выйти (<?= Html::encode(Yii::$app->user->identity->full_name) ?>)
                            </button>
                        </form>
                    </li>
                <?php endif; ?>
            </ul>
        </nav>
    </div>
</header>

<div class="main-content">
    <div class="container">
        <?php if (Yii::$app->session->hasFlash('success')): ?>
            <div class="alert alert-success">
                <button type="button" onclick="this.parentElement.style.display='none'" style="float:right; background:none; border:none; color:#155724; font-size:20px; cursor:pointer;">×</button>
                <?= Yii::$app->session->getFlash('success') ?>
            </div>
        <?php endif; ?>
        
        <?php if (Yii::$app->session->hasFlash('error')): ?>
            <div class="alert alert-danger">
                <button type="button" onclick="this.parentElement.style.display='none'" style="float:right; background:none; border:none; color:#721c24; font-size:20px; cursor:pointer;">×</button>
                <?= Yii::$app->session->getFlash('error') ?>
            </div>
        <?php endif; ?>
        
        <?php if (Yii::$app->session->hasFlash('info')): ?>
            <div class="alert alert-info">
                <button type="button" onclick="this.parentElement.style.display='none'" style="float:right; background:none; border:none; color:#0c5460; font-size:20px; cursor:pointer;">×</button>
                <?= Yii::$app->session->getFlash('info') ?>
            </div>
        <?php endif; ?>
        
        <?= $content ?>
    </div>
</div>

<footer class="footer">
    <div class="container">
        <div class="footer-content">
            <div class="footer-section">
                <h5>Коммуналка</h5>
                <p>Портал для передачи показаний за коммунальные услуги. Удобно, быстро, надежно.</p>
            </div>
            
            <div class="footer-section">
                <h5>Контакты</h5>
                <p><i class="fas fa-phone"></i> 8(800)123-45-67</p>
                <p><i class="fas fa-envelope"></i> support@kommunalka.ru</p>
                <p><i class="fas fa-clock"></i> Пн-Пт: 9:00-18:00</p>
            </div>
            
            <div class="footer-section">
                <h5>Полезные ссылки</h5>
                <ul style="list-style: none; padding: 0;">
                    <li><a href="<?= Url::to(['site/index']) ?>" style="color: white; text-decoration: none;">Главная</a></li>
                    <li><a href="<?= Url::to(['site/login']) ?>" style="color: white; text-decoration: none;">Войти</a></li>
                    <li><a href="<?= Url::to(['site/signup']) ?>" style="color: white; text-decoration: none;">Регистрация</a></li>
                </ul>
            </div>
        </div>
        
        <div class="footer-bottom">
            <p>&copy; <?= date('Y') ?> Коммуналка. Все права защищены.</p>
        </div>
    </div>
</footer>

<?php $this->endBody() ?>
</body>
</html>
<?php $this->endPage() ?>