<?php

use yii\helpers\Html;
use yii\helpers\Url;
use yii\grid\GridView;

$this->title = 'Панель администратора';
$this->params['breadcrumbs'][] = $this->title;
?>

<div class="admin-index">
    <h1 style="margin-bottom: 30px;"><?= Html::encode($this->title) ?></h1>

    <!-- Статистика -->
    <div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(200px, 1fr)); gap: 20px; margin-bottom: 30px;">
        <div style="background: white; border-radius: 8px; padding: 20px; box-shadow: 0 2px 10px rgba(0,0,0,0.05); border: 1px solid #e0e0e0;">
            <div style="display: flex; align-items: center; gap: 15px;">
                <div style="background: #3498db; width: 50px; height: 50px; border-radius: 8px; display: flex; align-items: center; justify-content: center;">
                    <i class="fas fa-users" style="color: white; font-size: 1.5rem;"></i>
                </div>
                <div>
                    <p style="margin: 0 0 5px 0; color: #666; font-size: 0.9rem;">Всего пользователей</p>
                    <p style="margin: 0; font-weight: bold; font-size: 1.5rem;"><?= $dataProvider->getTotalCount() ?></p>
                </div>
            </div>
        </div>

        <div style="background: white; border-radius: 8px; padding: 20px; box-shadow: 0 2px 10px rgba(0,0,0,0.05); border: 1px solid #e0e0e0;">
            <div style="display: flex; align-items: center; gap: 15px;">
                <div style="background: #27ae60; width: 50px; height: 50px; border-radius: 8px; display: flex; align-items: center; justify-content: center;">
                    <i class="fas fa-clipboard-list" style="color: white; font-size: 1.5rem;"></i>
                </div>
                <div>
                    <p style="margin: 0 0 5px 0; color: #666; font-size: 0.9rem;">Новые заявки</p>
                    <p style="margin: 0; font-weight: bold; font-size: 1.5rem;">
                        <?= \app\models\MeterReading::find()->where(['status' => 'Новая'])->count() ?>
                    </p>
                </div>
            </div>
        </div>

        <div style="background: white; border-radius: 8px; padding: 20px; box-shadow: 0 2px 10px rgba(0,0,0,0.05); border: 1px solid #e0e0e0;">
            <div style="display: flex; align-items: center; gap: 15px;">
                <div style="background: #e74c3c; width: 50px; height: 50px; border-radius: 8px; display: flex; align-items: center; justify-content: center;">
                    <i class="fas fa-exclamation-triangle" style="color: white; font-size: 1.5rem;"></i>
                </div>
                <div>
                    <p style="margin: 0 0 5px 0; color: #666; font-size: 0.9rem;">Ошибки</p>
                    <p style="margin: 0; font-weight: bold; font-size: 1.5rem;">
                        <?= \app\models\MeterReading::find()->where(['status' => 'Ошибка в переданных показаниях'])->count() ?>
                    </p>
                </div>
            </div>
        </div>

        <div style="background: white; border-radius: 8px; padding: 20px; box-shadow: 0 2px 10px rgba(0,0,0,0.05); border: 1px solid #e0e0e0;">
            <div style="display: flex; align-items: center; gap: 15px;">
                <div style="background: #9b59b6; width: 50px; height: 50px; border-radius: 8px; display: flex; align-items: center; justify-content: center;">
                    <i class="fas fa-ruble-sign" style="color: white; font-size: 1.5rem;"></i>
                </div>
                <div>
                    <p style="margin: 0 0 5px 0; color: #666; font-size: 0.9rem;">Общая сумма</p>
                    <p style="margin: 0; font-weight: bold; font-size: 1.5rem;">
                        <?= Yii::$app->formatter->asCurrency(
                            \app\models\MeterReading::find()->sum('amount') ?? 0
                        ) ?>
                    </p>
                </div>
            </div>
        </div>
    </div>

    <!-- Навигация -->
    <div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(250px, 1fr)); gap: 20px; margin-bottom: 30px;">
        <a href="<?= Url::to(['users']) ?>" style="text-decoration: none;">
            <div style="background: white; border-radius: 8px; padding: 25px; box-shadow: 0 2px 10px rgba(0,0,0,0.05); border: 2px solid #e0e0e0; transition: all 0.3s; cursor: pointer;">
                <div style="text-align: center;">
                    <i class="fas fa-users" style="font-size: 2.5rem; color: #3498db; margin-bottom: 15px;"></i>
                    <h3 style="margin: 0 0 10px 0; color: #2c3e50;">Пользователи</h3>
                    <p style="margin: 0; color: #666;">Управление пользователями системы</p>
                </div>
            </div>
        </a>

        <a href="<?= Url::to(['news']) ?>" style="text-decoration: none;">
            <div style="background: white; border-radius: 8px; padding: 25px; box-shadow: 0 2px 10px rgba(0,0,0,0.05); border: 2px solid #e0e0e0; transition: all 0.3s; cursor: pointer;">
                <div style="text-align: center;">
                    <i class="fas fa-newspaper" style="font-size: 2.5rem; color: #27ae60; margin-bottom: 15px;"></i>
                    <h3 style="margin: 0 0 10px 0; color: #2c3e50;">Новости</h3>
                    <p style="margin: 0; color: #666;">Управление новостями и объявлениями</p>
                </div>
            </div>
        </a>

        <a href="<?= Url::to(['services']) ?>" style="text-decoration: none;">
            <div style="background: white; border-radius: 8px; padding: 25px; box-shadow: 0 2px 10px rgba(0,0,0,0.05); border: 2px solid #e0e0e0; transition: all 0.3s; cursor: pointer;">
                <div style="text-align: center;">
                    <i class="fas fa-bolt" style="font-size: 2.5rem; color: #f39c12; margin-bottom: 15px;"></i>
                    <h3 style="margin: 0 0 10px 0; color: #2c3e50;">Услуги</h3>
                    <p style="margin: 0; color: #666;">Управление тарифами и услугами</p>
                </div>
            </div>
        </a>

        <a href="<?= Url::to(['stats']) ?>" style="text-decoration: none;">
            <div style="background: white; border-radius: 8px; padding: 25px; box-shadow: 0 2px 10px rgba(0,0,0,0.05); border: 2px solid #e0e0e0; transition: all 0.3s; cursor: pointer;">
                <div style="text-align: center;">
                    <i class="fas fa-chart-bar" style="font-size: 2.5rem; color: #9b59b6; margin-bottom: 15px;"></i>
                    <h3 style="margin: 0 0 10px 0; color: #2c3e50;">Статистика</h3>
                    <p style="margin: 0; color: #666;">Просмотр статистики и отчетов</p>
                </div>
            </div>
        </a>
    </div>

    <!-- Последние заявки -->
    <div class="card" style="margin-bottom: 30px;">
        <div class="card-header" style="display: flex; justify-content: space-between; align-items: center;">
            <h2 class="card-title" style="margin: 0;">Последние заявки</h2>
            <?= Html::a('Все заявки', '#', ['class' => 'btn btn-primary btn-sm']) ?>
        </div>
        <div class="card-body">
            <?php if ($dataProvider->getTotalCount() > 0): ?>
                <table class="table">
                    <thead>
                        <tr>
                            <th>ID</th>
                            <th>Пользователь</th>
                            <th>Услуга</th>
                            <th>Дата</th>
                            <th>Сумма</th>
                            <th>Статус</th>
                            <th>Действия</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($dataProvider->getModels() as $model): ?>
                            <tr>
                                <td>#<?= $model->id ?></td>
                                <td>
                                    <?= Html::encode($model->user->full_name ?? '') ?><br>
                                    <small style="color: #666;"><?= Html::encode($model->user->phone ?? '') ?></small>
                                </td>
                                <td><?= Html::encode($model->serviceCategory->name ?? '') ?></td>
                                <td><?= Yii::$app->formatter->asDate($model->reading_date) ?></td>
                                <td><?= Yii::$app->formatter->asCurrency($model->amount) ?></td>
                                <td>
                                    <span style="display: inline-block; padding: 4px 12px; border-radius: 4px; font-size: 0.9rem; 
                                          background: <?= $model->status === 'Новая' ? '#fff3cd' : 
                                                       ($model->status === 'Показания приняты' ? '#d1ecf1' : 
                                                       ($model->status === 'Оплачено' ? '#d4edda' : '#f8d7da')) ?>; 
                                          color: <?= $model->status === 'Новая' ? '#856404' : 
                                                  ($model->status === 'Показания приняты' ? '#0c5460' : 
                                                  ($model->status === 'Оплачено' ? '#155724' : '#721c24')) ?>; 
                                          border: 1px solid <?= $model->status === 'Новая' ? '#ffeaa7' : 
                                                              ($model->status === 'Показания приняты' ? '#bee5eb' : 
                                                              ($model->status === 'Оплачено' ? '#c3e6cb' : '#f5c6cb')) ?>;">
                                        <?= Html::encode($model->status) ?>
                                    </span>
                                </td>
                                <td>
                                    <?= Html::a('Просмотр', ['view', 'id' => $model->id], [
                                        'class' => 'btn btn-link btn-sm',
                                        'style' => 'padding: 2px 8px;'
                                    ]) ?>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            <?php else: ?>
                <p style="text-align: center; color: #666; padding: 40px 0;">Заявки отсутствуют</p>
            <?php endif; ?>
        </div>
    </div>

    <!-- Быстрые действия -->
    <div class="card">
        <div class="card-header">
            <h2 class="card-title" style="margin: 0;">Быстрые действия</h2>
        </div>
        <div class="card-body">
            <div style="display: flex; gap: 15px; flex-wrap: wrap;">
                <?= Html::a('<i class="fas fa-user-plus"></i> Добавить пользователя', ['users'], ['class' => 'btn btn-primary']) ?>
                <?= Html::a('<i class="fas fa-plus"></i> Добавить новость', ['news'], ['class' => 'btn btn-success']) ?>
                <?= Html::a('<i class="fas fa-cog"></i> Настройки тарифов', ['services'], ['class' => 'btn btn-info']) ?>
                <?= Html::a('<i class="fas fa-file-export"></i> Экспорт данных', '#', ['class' => 'btn btn-warning']) ?>
            </div>
        </div>
    </div>
</div>

<script>
document.addEventListener('DOMContentLayout', function() {
    // Анимация для карточек
    const cards = document.querySelectorAll('.card');
    cards.forEach(card => {
        card.style.transition = 'transform 0.3s, box-shadow 0.3s';
        card.addEventListener('mouseenter', function() {
            this.style.transform = 'translateY(-5px)';
            this.style.boxShadow = '0 10px 30px rgba(0,0,0,0.1)';
        });
        card.addEventListener('mouseleave', function() {
            this.style.transform = 'translateY(0)';
            this.style.boxShadow = '0 2px 10px rgba(0,0,0,0.05)';
        });
    });
    
    // Анимация для ссылок-карточек
    const linkCards = document.querySelectorAll('a > div');
    linkCards.forEach(card => {
        card.addEventListener('mouseenter', function() {
            this.style.transform = 'translateY(-5px)';
            this.style.boxShadow = '0 10px 25px rgba(0,0,0,0.1)';
            this.style.borderColor = '#3498db';
        });
        card.addEventListener('mouseleave', function() {
            this.style.transform = 'translateY(0)';
            this.style.boxShadow = '0 2px 10px rgba(0,0,0,0.05)';
            this.style.borderColor = '#e0e0e0';
        });
    });
});
</script>