<?php

namespace app\models;

use Yii;
use yii\db\ActiveRecord;

/**
 * This is the model class for table "service_category".
 *
 * @property int $id
 * @property string $name
 * @property string $unit
 * @property string $tariff
 * @property int $created_at
 * @property int $updated_at
 */
class ServiceCategory extends ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return '{{%service_category}}';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['name', 'unit', 'tariff'], 'required'],
            [['tariff'], 'number'],
            [['created_at', 'updated_at'], 'integer'],
            [['name'], 'string', 'max' => 100],
            [['unit'], 'string', 'max' => 20],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'name' => 'Название услуги',
            'unit' => 'Единица измерения',
            'tariff' => 'Тариф',
            'created_at' => 'Дата создания',
            'updated_at' => 'Дата обновления',
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function beforeSave($insert)
    {
        if (parent::beforeSave($insert)) {
            if ($insert) {
                $this->created_at = time();
            }
            $this->updated_at = time();
            return true;
        }
        return false;
    }

    /**
     * Получить все активные категории
     */
    public static function getAllCategories()
    {
        return self::find()->orderBy(['name' => SORT_ASC])->all();
    }

    /**
     * Получить категорию по ID
     */
    public static function getCategory($id)
    {
        return self::findOne($id);
    }

    /**
     * Получить тариф по ID категории
     */
    public static function getTariff($categoryId)
    {
        $category = self::findOne($categoryId);
        return $category ? $category->tariff : 0;
    }
}