<?php

use yii\db\Migration;

/**
 * Handles the creation of table `{{%payment}}`.
 */
class m260205_185734_create_payment_table extends Migration
{
    /**
     * {@inheritdoc}
     */
     public function safeUp()
    {
        $tableOptions = null;
        if ($this->db->driverName === 'mysql') {
            $tableOptions = 'CHARACTER SET utf8 COLLATE utf8_unicode_ci ENGINE=InnoDB';
        }

        $this->createTable('{{%payment}}', [
            'id' => $this->primaryKey(),
            'user_id' => $this->integer()->notNull()->comment('ID пользователя'),
            'meter_reading_id' => $this->integer()->null()->comment('ID показаний'),
            'amount' => $this->decimal(10, 2)->notNull()->comment('Сумма'),
            'payment_date' => $this->date()->notNull()->comment('Дата платежа'),
            'status' => $this->string(50)->notNull()->defaultValue('Ожидает оплаты')->comment('Статус'),
            'payment_method' => $this->string(100)->null()->comment('Способ оплаты'),
            'transaction_id' => $this->string(255)->null()->comment('ID транзакции'),
            'created_at' => $this->integer()->notNull()->comment('Дата создания'),
        ], $tableOptions);

        // Внешние ключи
        $this->addForeignKey(
            'fk-payment-user_id',
            '{{%payment}}',
            'user_id',
            '{{%user}}',
            'id',
            'CASCADE',
            'CASCADE'
        );

        $this->addForeignKey(
            'fk-payment-meter_reading_id',
            '{{%payment}}',
            'meter_reading_id',
            '{{%meter_reading}}',
            'id',
            'SET NULL',
            'CASCADE'
        );

        // Индексы
        $this->createIndex('idx-payment-user_id', '{{%payment}}', 'user_id');
        $this->createIndex('idx-payment-status', '{{%payment}}', 'status');
        $this->createIndex('idx-payment-payment_date', '{{%payment}}', 'payment_date');
    }

    /**
     * {@inheritdoc}
     */
    public function safeDown()
    {
        $this->dropForeignKey('fk-payment-meter_reading_id', '{{%payment}}');
        $this->dropForeignKey('fk-payment-user_id', '{{%payment}}');
        $this->dropTable('{{%payment}}');
    }
}
