<?php

use yii\db\Migration;

/**
 * Handles the creation of table `{{%news}}`.
 */
class m260205_185013_create_news_table extends Migration
{
    /**
     * {@inheritdoc}
     */
     public function safeUp()
    {
        $tableOptions = null;
        if ($this->db->driverName === 'mysql') {
            $tableOptions = 'CHARACTER SET utf8 COLLATE utf8_unicode_ci ENGINE=InnoDB';
        }

        $this->createTable('{{%news}}', [
            'id' => $this->primaryKey(),
            'title' => $this->string(255)->notNull()->comment('Заголовок'),
            'content' => $this->text()->notNull()->comment('Содержание'),
            'publish_date' => $this->date()->notNull()->comment('Дата публикации'),
            'is_active' => $this->boolean()->defaultValue(true)->comment('Активна'),
            'created_at' => $this->integer()->notNull()->comment('Дата создания'),
            'updated_at' => $this->integer()->null()->comment('Дата обновления'),
        ], $tableOptions);

        // Добавляем тестовые новости
        $this->batchInsert('{{%news}}', 
            ['title', 'content', 'publish_date', 'is_active', 'created_at', 'updated_at'], 
            [
                [
                    'Сроки подачи показаний', 
                    'Показания за текущий месяц принимаются до 25 числа. Пожалуйста, передавайте показания вовремя, чтобы избежать начисления по среднему.',
                    date('Y-m-d'),
                    1,
                    time(),
                    time()
                ],
                [
                    'Обновление тарифов', 
                    'С 1 января вводятся новые тарифы на коммунальные услуги. Электричество: 5.03 руб/кВт·ч, Газ: 7.39 руб/м³, Вода: 48.24 руб/м³.',
                    date('Y-m-d'),
                    1,
                    time(),
                    time()
                ],
                [
                    'Технические работы', 
                    '29 числа с 00:00 до 06:00 будут проводиться плановые технические работы на портале. В это время сервис будет недоступен.',
                    date('Y-m-d', strtotime('+2 days')),
                    1,
                    time(),
                    time()
                ],
                [
                    'Новый функционал', 
                    'Добавлена возможность просмотра истории всех переданных показаний. Теперь вы можете отслеживать свой расход за любой период.',
                    date('Y-m-d', strtotime('-5 days')),
                    1,
                    time(),
                    time()
                ],
            ]
        );

        // Индексы
        $this->createIndex('idx-news-publish_date', '{{%news}}', 'publish_date');
        $this->createIndex('idx-news-is_active', '{{%news}}', 'is_active');
    }

    /**
     * {@inheritdoc}
     */
    public function safeDown()
    {
        $this->dropTable('{{%news}}');
    }
}
