<?php

use yii\db\Migration;

/**
 * Handles the creation of table `{{%meter_reading}}`.
 */
class m260205_184931_create_meter_reading_table extends Migration
{
    /**
     * {@inheritdoc}
     */
    public function safeUp()
    {
        $tableOptions = null;
        if ($this->db->driverName === 'mysql') {
            $tableOptions = 'CHARACTER SET utf8 COLLATE utf8_unicode_ci ENGINE=InnoDB';
        }

        $this->createTable('{{%meter_reading}}', [
            'id' => $this->primaryKey(),
            'user_id' => $this->integer()->notNull()->comment('ID пользователя'),
            'service_category_id' => $this->integer()->notNull()->comment('ID категории услуг'),
            'previous_reading' => $this->decimal(10, 3)->notNull()->comment('Предыдущие показания'),
            'current_reading' => $this->decimal(10, 3)->notNull()->comment('Текущие показания'),
            'consumption' => $this->decimal(10, 3)->comment('Расход'),
            'amount' => $this->decimal(10, 2)->comment('Сумма к оплате'),
            'status' => $this->string(50)->notNull()->defaultValue('Новая')->comment('Статус'),
            'reading_date' => $this->date()->notNull()->comment('Дата передачи показаний'),
            'created_at' => $this->integer()->notNull()->comment('Дата создания'),
            'updated_at' => $this->integer()->notNull()->comment('Дата обновления'),
        ], $tableOptions);

        // Внешние ключи
        $this->addForeignKey(
            'fk-meter_reading-user_id',
            '{{%meter_reading}}',
            'user_id',
            '{{%user}}',
            'id',
            'CASCADE',
            'CASCADE'
        );

        $this->addForeignKey(
            'fk-meter_reading-service_category_id',
            '{{%meter_reading}}',
            'service_category_id',
            '{{%service_category}}',
            'id',
            'CASCADE',
            'CASCADE'
        );

        // Индексы
        $this->createIndex('idx-meter_reading-user_id', '{{%meter_reading}}', 'user_id');
        $this->createIndex('idx-meter_reading-service_category_id', '{{%meter_reading}}', 'service_category_id');
        $this->createIndex('idx-meter_reading-status', '{{%meter_reading}}', 'status');
        $this->createIndex('idx-meter_reading-reading_date', '{{%meter_reading}}', 'reading_date');
        $this->createIndex('idx-meter_reading-created_at', '{{%meter_reading}}', 'created_at');
    }

    /**
     * {@inheritdoc}
     */
    public function safeDown()
    {
        $this->dropForeignKey('fk-meter_reading-service_category_id', '{{%meter_reading}}');
        $this->dropForeignKey('fk-meter_reading-user_id', '{{%meter_reading}}');
        $this->dropTable('{{%meter_reading}}');
    }
}
